<?php
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/functions.php';

// Only allow POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Method not allowed']);
    exit;
}

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);
$phone = $input['phone'] ?? '';

// Validate
$phone = convertPersianToEnglish($phone);
if (!validateMobile($phone)) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'شماره موبایل نامعتبر است']);
    exit;
}

// Check if user already exists
$existingUser = getUserByMobile($phone);
if ($existingUser) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'این شماره موبایل قبلاً ثبت شده است']);
    exit;
}

// Register user using the registerWithOTP function
$registerResult = registerWithOTP($phone, null, null, null);

if ($registerResult['success']) {
    echo json_encode([
        'status' => 'ok',
        'message' => $registerResult['message'],
        'token' => $registerResult['token'],
        'user' => $registerResult['user']
    ]);
} else {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $registerResult['message']]);
}

