<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/api/esim-api.php';

echo "<h1>🔄 همگام‌سازی ICCID ها</h1>";
echo "<style>
body{font-family:Tahoma;padding:20px;direction:rtl;line-height:2;background:#f5f5f5;} 
.success{color:green;font-weight:bold;} 
.error{color:red;font-weight:bold;} 
.info{color:blue;font-weight:bold;} 
.warning{color:orange;font-weight:bold;}
pre{background:#fff;padding:15px;border-radius:8px;direction:ltr;overflow-x:auto;border:1px solid #ddd;font-size:12px;}
.box{background:white;padding:20px;margin:20px 0;border-radius:10px;box-shadow:0 2px 10px rgba(0,0,0,0.1);}
table{width:100%;border-collapse:collapse;margin:15px 0;}
table th{background:#667eea;color:white;padding:12px;text-align:right;}
table td{padding:10px;border:1px solid #ddd;}
table tr:nth-child(even){background:#f9f9f9;}
</style>";

$api = new eSIMAPI();
$conn = getDBConnection();

// Get all paid orders
$stmt = $conn->prepare("SELECT id, iccid, esim_tran_no, package_code, package_name, country_code, country_name, created_at FROM orders WHERE status = 'paid' ORDER BY created_at DESC");
$stmt->execute();
$result = $stmt->get_result();
$orders = [];
while ($row = $result->fetch_assoc()) {
    $orders[] = $row;
}
$stmt->close();

echo "<div class='box'>";
echo "<h2>📊 سفارشات پرداخت شده</h2>";
echo "<p class='info'>تعداد: " . count($orders) . "</p>";

if (empty($orders)) {
    echo "<p class='error'>هیچ سفارش پرداخت شده‌ای وجود ندارد</p>";
    echo "</div>";
    $conn->close();
    exit;
}

echo "<table>";
echo "<tr><th>ID</th><th>تاریخ</th><th>بسته</th><th>ICCID فعلی</th><th>esimTranNo</th><th>وضعیت</th></tr>";

foreach ($orders as $order) {
    $shortIccid = $order['iccid'] ? substr($order['iccid'], 0, 15) . '...' : 'ندارد';
    $status = $order['iccid'] ? '✅' : '❌';
    $date = date('Y-m-d', strtotime($order['created_at']));
    
    echo "<tr>";
    echo "<td>" . $order['id'] . "</td>";
    echo "<td>" . $date . "</td>";
    echo "<td>" . htmlspecialchars($order['package_name']) . "</td>";
    echo "<td><code>" . $shortIccid . "</code></td>";
    echo "<td>" . ($order['esim_tran_no'] ?? 'ندارد') . "</td>";
    echo "<td>" . $status . "</td>";
    echo "</tr>";
}

echo "</table>";
echo "</div>";

// Now let's query API for each order
echo "<div class='box'>";
echo "<h2>🔍 بررسی ICCID های واقعی از API</h2>";

foreach ($orders as $order) {
    echo "<hr style='margin:30px 0;'>";
    echo "<h3>📦 سفارش #{$order['id']} - {$order['package_name']}</h3>";
    
    if (empty($order['iccid'])) {
        echo "<p class='error'>❌ این سفارش ICCID ندارد، نمی‌توان از API جستجو کرد</p>";
        continue;
    }
    
    echo "<p><strong>تاریخ:</strong> " . date('Y-m-d H:i', strtotime($order['created_at'])) . "</p>";
    echo "<p><strong>ICCID فعلی در دیتابیس:</strong> <code>{$order['iccid']}</code></p>";
    
    // Query API with ICCID
    echo "<p class='info'>🔄 در حال جستجو در API با ICCID...</p>";
    
    $apiResponse = $api->getESIMDetails($order['iccid']);
    
    if ($apiResponse && isset($apiResponse['success']) && $apiResponse['success'] === true) {
        if (isset($apiResponse['obj']['esimList']) && !empty($apiResponse['obj']['esimList'])) {
            $esimData = $apiResponse['obj']['esimList'][0];
            $realIccid = $esimData['iccid'] ?? '';
            $esimTranNo = $esimData['esimTranNo'] ?? '';
            
            echo "<p class='success'>✅ eSIM پیدا شد در API</p>";
            echo "<p><strong>ICCID واقعی از API:</strong> <code style='background:#d1fae5;padding:5px;'>$realIccid</code></p>";
            echo "<p><strong>esimTranNo از API:</strong> <code style='background:#dbeafe;padding:5px;'>$esimTranNo</code></p>";
            
            // Compare
            if ($order['iccid'] !== $realIccid) {
                echo "<p class='error'>❌ ICCID در دیتابیس با API متفاوت است!</p>";
                
                // Update button
                echo "<form method='POST' style='margin:15px 0;'>";
                echo "<input type='hidden' name='order_id' value='{$order['id']}'>";
                echo "<input type='hidden' name='new_iccid' value='$realIccid'>";
                echo "<input type='hidden' name='new_esim_tran_no' value='$esimTranNo'>";
                echo "<button type='submit' name='update_iccid' style='background:#10b981;color:white;padding:10px 20px;border:none;border-radius:8px;cursor:pointer;font-weight:bold;'>";
                echo "🔄 به‌روزرسانی ICCID و esimTranNo";
                echo "</button>";
                echo "</form>";
            } else {
                echo "<p class='success'>✅ ICCID صحیح است</p>";
                
                // Check esimTranNo
                if (empty($order['esim_tran_no']) && !empty($esimTranNo)) {
                    echo "<p class='warning'>⚠️ esimTranNo در دیتابیس خالی است</p>";
                    
                    echo "<form method='POST' style='margin:15px 0;'>";
                    echo "<input type='hidden' name='order_id' value='{$order['id']}'>";
                    echo "<input type='hidden' name='new_esim_tran_no' value='$esimTranNo'>";
                    echo "<button type='submit' name='update_esim_tran_no' style='background:#3b82f6;color:white;padding:10px 20px;border:none;border-radius:8px;cursor:pointer;font-weight:bold;'>";
                    echo "🔄 به‌روزرسانی esimTranNo";
                    echo "</button>";
                    echo "</form>";
                }
            }
            
            // Show full API response
            echo "<details style='margin-top:15px;'>";
            echo "<summary style='cursor:pointer;color:#667eea;font-weight:bold;'>📄 نمایش پاسخ کامل API</summary>";
            echo "<pre>" . json_encode($esimData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
            echo "</details>";
            
        } else {
            echo "<p class='error'>❌ هیچ eSIM در API پیدا نشد</p>";
            echo "<pre>" . json_encode($apiResponse, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
        }
    } else {
        $errorCode = $apiResponse['errorCode'] ?? 'نامشخص';
        $errorMsg = $apiResponse['errorMsg'] ?? 'نامشخص';
        echo "<p class='error'>❌ خطا در API: $errorCode - $errorMsg</p>";
        echo "<pre>" . json_encode($apiResponse, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
    }
}

echo "</div>";

// Handle updates
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['update_iccid'])) {
        $orderId = intval($_POST['order_id']);
        $newIccid = $_POST['new_iccid'];
        $newEsimTranNo = $_POST['new_esim_tran_no'];
        
        $stmt = $conn->prepare("UPDATE orders SET iccid = ?, esim_tran_no = ? WHERE id = ?");
        $stmt->bind_param("ssi", $newIccid, $newEsimTranNo, $orderId);
        
        if ($stmt->execute()) {
            echo "<script>alert('✅ ICCID و esimTranNo با موفقیت به‌روز شد!'); window.location.reload();</script>";
        } else {
            echo "<script>alert('❌ خطا: " . $stmt->error . "');</script>";
        }
        $stmt->close();
    }
    
    if (isset($_POST['update_esim_tran_no'])) {
        $orderId = intval($_POST['order_id']);
        $newEsimTranNo = $_POST['new_esim_tran_no'];
        
        $stmt = $conn->prepare("UPDATE orders SET esim_tran_no = ? WHERE id = ?");
        $stmt->bind_param("si", $newEsimTranNo, $orderId);
        
        if ($stmt->execute()) {
            echo "<script>alert('✅ esimTranNo با موفقیت به‌روز شد!'); window.location.reload();</script>";
        } else {
            echo "<script>alert('❌ خطا: " . $stmt->error . "');</script>";
        }
        $stmt->close();
    }
}

$conn->close();

echo "<hr>";
echo "<div style='text-align:center;margin:30px 0;'>";
echo "<a href='/my-esims.php' style='background:#667eea;color:white;padding:15px 30px;border-radius:8px;text-decoration:none;display:inline-block;font-weight:bold;'>بازگشت به eSIM های من</a>";
echo "</div>";
?>

